/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.Utils;

public class QuotedPrintableCodec
implements BinaryDecoder,
BinaryEncoder,
StringDecoder,
StringEncoder {
    private final Charset charset;
    private static final BitSet PRINTABLE_CHARS;
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;

    public QuotedPrintableCodec() {
        this(Charsets.UTF_8);
    }

    public QuotedPrintableCodec(Charset charset) {
        this.charset = charset;
    }

    public QuotedPrintableCodec(String string) {
        this(Charset.forName(string));
    }

    private static final void encodeQuotedPrintable(int n2, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(61);
        char c2 = Character.toUpperCase(Character.forDigit(n2 >> 4 & 0xF, 16));
        char c3 = Character.toUpperCase(Character.forDigit(n2 & 0xF, 16));
        byteArrayOutputStream.write(c2);
        byteArrayOutputStream.write(c3);
    }

    public static final byte[] encodeQuotedPrintable(BitSet bitSet, byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (bitSet == null) {
            bitSet = PRINTABLE_CHARS;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int n2 : byArray) {
            int n3 = n2;
            if (n3 < 0) {
                n3 = 256 + n3;
            }
            if (bitSet.get(n3)) {
                byteArrayOutputStream.write(n3);
                continue;
            }
            QuotedPrintableCodec.encodeQuotedPrintable(n3, byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] decodeQuotedPrintable(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byArray[i2];
            if (by == 61) {
                try {
                    int n2 = Utils.digit16(byArray[++i2]);
                    int n3 = Utils.digit16(byArray[++i2]);
                    byteArrayOutputStream.write((char)((n2 << 4) + n3));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new DecoderException("Invalid quoted-printable encoding", arrayIndexOutOfBoundsException);
                }
            }
            byteArrayOutputStream.write(by);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] encode(byte[] byArray) {
        return QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, byArray);
    }

    @Override
    public byte[] decode(byte[] byArray) {
        return QuotedPrintableCodec.decodeQuotedPrintable(byArray);
    }

    @Override
    public String encode(String string) {
        return this.encode(string, this.getCharset());
    }

    public String decode(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(string)), charset);
    }

    public String decode(String string, String string2) {
        if (string == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(string)), string2);
    }

    @Override
    public String decode(String string) {
        return this.decode(string, this.getCharset());
    }

    @Override
    public Object encode(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.encode((byte[])object);
        }
        if (object instanceof String) {
            return this.encode((String)object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be quoted-printable encoded");
    }

    @Override
    public Object decode(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be quoted-printable decoded");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }

    public String encode(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(string.getBytes(charset)));
    }

    public String encode(String string, String string2) {
        if (string == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(string.getBytes(string2)));
    }

    static {
        int n2;
        PRINTABLE_CHARS = new BitSet(256);
        for (n2 = 33; n2 <= 60; ++n2) {
            PRINTABLE_CHARS.set(n2);
        }
        for (n2 = 62; n2 <= 126; ++n2) {
            PRINTABLE_CHARS.set(n2);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
    }
}

