/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.util.concurrent.Future;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.ContentResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;

public class Async {
    private Executor executor;
    private java.util.concurrent.Executor concurrentExec;

    public static Async newInstance() {
        return new Async();
    }

    Async() {
    }

    public Async use(Executor executor) {
        this.executor = executor;
        return this;
    }

    public Async use(java.util.concurrent.Executor executor) {
        this.concurrentExec = executor;
        return this;
    }

    public <T> Future<T> execute(Request request, ResponseHandler<T> responseHandler, FutureCallback<T> futureCallback) {
        BasicFuture<T> basicFuture = new BasicFuture<T>(futureCallback);
        ExecRunnable<T> execRunnable = new ExecRunnable<T>(basicFuture, request, this.executor != null ? this.executor : Executor.newInstance(), responseHandler);
        if (this.concurrentExec != null) {
            this.concurrentExec.execute(execRunnable);
        } else {
            Thread thread = new Thread(execRunnable);
            thread.setDaemon(true);
            thread.start();
        }
        return basicFuture;
    }

    public <T> Future<T> execute(Request request, ResponseHandler<T> responseHandler) {
        return this.execute(request, responseHandler, null);
    }

    public Future<Content> execute(Request request, FutureCallback<Content> futureCallback) {
        return this.execute(request, new ContentResponseHandler(), futureCallback);
    }

    public Future<Content> execute(Request request) {
        return this.execute(request, new ContentResponseHandler(), null);
    }

    static class ExecRunnable<T>
    implements Runnable {
        private final BasicFuture<T> future;
        private final Request request;
        private final Executor executor;
        private final ResponseHandler<T> handler;

        ExecRunnable(BasicFuture<T> basicFuture, Request request, Executor executor, ResponseHandler<T> responseHandler) {
            this.future = basicFuture;
            this.request = request;
            this.executor = executor;
            this.handler = responseHandler;
        }

        @Override
        public void run() {
            try {
                Response response = this.executor.execute(this.request);
                T t2 = response.handleResponse(this.handler);
                this.future.completed(t2);
            }
            catch (Exception exception) {
                this.future.failed(exception);
            }
        }
    }
}

