/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.util.Args;

class InternalHttpRequest
extends AbstractHttpMessage
implements Configurable,
HttpExecutionAware,
HttpUriRequest {
    private final String method;
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;
    private final AtomicBoolean aborted;
    private final AtomicReference<Cancellable> cancellableRef;

    InternalHttpRequest(String string, URI uRI) {
        Args.notBlank(string, "Method");
        Args.notNull(uRI, "Request URI");
        this.method = string;
        this.uri = uRI;
        this.aborted = new AtomicBoolean(false);
        this.cancellableRef = new AtomicReference<Object>(null);
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpVersion.HTTP_1_1;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void abort() {
        Cancellable cancellable;
        if (this.aborted.compareAndSet(false, true) && (cancellable = (Cancellable)this.cancellableRef.getAndSet(null)) != null) {
            cancellable.cancel();
        }
    }

    @Override
    public boolean isAborted() {
        return this.aborted.get();
    }

    @Override
    public void setCancellable(Cancellable cancellable) {
        if (!this.aborted.get()) {
            this.cancellableRef.set(cancellable);
        }
    }

    @Override
    public RequestLine getRequestLine() {
        ProtocolVersion protocolVersion = this.getProtocolVersion();
        URI uRI = this.getURI();
        String string = null;
        if (uRI != null) {
            string = uRI.toASCIIString();
        }
        if (string == null || string.isEmpty()) {
            string = "/";
        }
        return new BasicRequestLine(this.getMethod(), string, protocolVersion);
    }

    @Override
    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig requestConfig) {
        this.config = requestConfig;
    }

    public void setURI(URI uRI) {
        this.uri = uRI;
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

