/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth.win;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.win.CurrentWindowsCredentials;
import org.apache.http.util.Args;

public class WindowsCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider provider;

    public WindowsCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.provider = Args.notNull(credentialsProvider, "Credentials provider");
    }

    @Override
    public Credentials getCredentials(AuthScope authScope) {
        String string = authScope.getScheme();
        if ("NTLM".equalsIgnoreCase(string) || "Negotiate".equalsIgnoreCase(string)) {
            return CurrentWindowsCredentials.INSTANCE;
        }
        return this.provider.getCredentials(authScope);
    }

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.provider.setCredentials(authScope, credentials);
    }

    @Override
    public void clear() {
        this.provider.clear();
    }
}

