/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import org.apache.http.client.cache.Resource;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.util.Args;

class CombinedEntity
extends AbstractHttpEntity {
    private final Resource resource;
    private final InputStream combinedStream;

    CombinedEntity(Resource resource, InputStream inputStream) {
        this.resource = resource;
        this.combinedStream = new SequenceInputStream(new ResourceStream(resource.getInputStream()), inputStream);
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public InputStream getContent() {
        return this.combinedStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) {
        Args.notNull(outputStream, "Output stream");
        InputStream inputStream = this.getContent();
        try {
            int n2;
            byte[] byArray = new byte[2048];
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private void dispose() {
        this.resource.dispose();
    }

    class ResourceStream
    extends FilterInputStream {
        protected ResourceStream(InputStream inputStream) {
            super(inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                CombinedEntity.this.dispose();
            }
        }
    }
}

