/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache.ehcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheEntrySerializer;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.DefaultHttpCacheEntrySerializer;

public class EhcacheHttpCacheStorage
implements HttpCacheStorage {
    private final Ehcache cache;
    private final HttpCacheEntrySerializer serializer;
    private final int maxUpdateRetries;

    public EhcacheHttpCacheStorage(Ehcache ehcache) {
        this(ehcache, CacheConfig.DEFAULT, new DefaultHttpCacheEntrySerializer());
    }

    public EhcacheHttpCacheStorage(Ehcache ehcache, CacheConfig cacheConfig) {
        this(ehcache, cacheConfig, new DefaultHttpCacheEntrySerializer());
    }

    public EhcacheHttpCacheStorage(Ehcache ehcache, CacheConfig cacheConfig, HttpCacheEntrySerializer httpCacheEntrySerializer) {
        this.cache = ehcache;
        this.maxUpdateRetries = cacheConfig.getMaxUpdateRetries();
        this.serializer = httpCacheEntrySerializer;
    }

    @Override
    public synchronized void putEntry(String string, HttpCacheEntry httpCacheEntry) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.serializer.writeTo(httpCacheEntry, byteArrayOutputStream);
        this.cache.put(new Element((Serializable)((Object)string), (Serializable)byteArrayOutputStream.toByteArray()));
    }

    @Override
    public synchronized HttpCacheEntry getEntry(String string) {
        Element element = this.cache.get((Serializable)((Object)string));
        if (element == null) {
            return null;
        }
        byte[] byArray = (byte[])element.getValue();
        return this.serializer.readFrom(new ByteArrayInputStream(byArray));
    }

    @Override
    public synchronized void removeEntry(String string) {
        this.cache.remove((Serializable)((Object)string));
    }

    @Override
    public synchronized void updateEntry(String string, HttpCacheUpdateCallback httpCacheUpdateCallback) {
        int n2 = 0;
        do {
            Object object;
            Element element = this.cache.get((Serializable)((Object)string));
            HttpCacheEntry httpCacheEntry = null;
            if (element != null) {
                object = (byte[])element.getValue();
                httpCacheEntry = this.serializer.readFrom(new ByteArrayInputStream((byte[])object));
            }
            object = httpCacheUpdateCallback.update(httpCacheEntry);
            if (httpCacheEntry == null) {
                this.putEntry(string, (HttpCacheEntry)object);
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.serializer.writeTo((HttpCacheEntry)object, byteArrayOutputStream);
            Element element2 = new Element((Serializable)((Object)string), (Serializable)byteArrayOutputStream.toByteArray());
            if (!this.cache.replace(element, element2)) continue;
            return;
        } while (++n2 <= this.maxUpdateRetries);
        throw new HttpCacheUpdateException("Failed to update");
    }
}

