/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.BitSet;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

public class TokenParser {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char SP = ' ';
    public static final char HT = '\t';
    public static final char DQUOTE = '\"';
    public static final char ESCAPE = '\\';
    public static final TokenParser INSTANCE = new TokenParser();

    public static BitSet INIT_BITSET(int ... nArray) {
        BitSet bitSet = new BitSet();
        for (int n2 : nArray) {
            bitSet.set(n2);
        }
        return bitSet;
    }

    public static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n';
    }

    public String parseToken(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (!parserCursor.atEnd()) {
            char c2 = charArrayBuffer.charAt(parserCursor.getPos());
            if (bitSet != null && bitSet.get(c2)) break;
            if (TokenParser.isWhitespace(c2)) {
                this.skipWhiteSpace(charArrayBuffer, parserCursor);
                bl = true;
                continue;
            }
            if (bl && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            this.copyContent(charArrayBuffer, parserCursor, bitSet, stringBuilder);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public String parseValue(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (!parserCursor.atEnd()) {
            char c2 = charArrayBuffer.charAt(parserCursor.getPos());
            if (bitSet != null && bitSet.get(c2)) break;
            if (TokenParser.isWhitespace(c2)) {
                this.skipWhiteSpace(charArrayBuffer, parserCursor);
                bl = true;
                continue;
            }
            if (c2 == '\"') {
                if (bl && stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                this.copyQuotedContent(charArrayBuffer, parserCursor, stringBuilder);
                bl = false;
                continue;
            }
            if (bl && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            this.copyUnquotedContent(charArrayBuffer, parserCursor, bitSet, stringBuilder);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public void skipWhiteSpace(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        char c2;
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getPos();
        int n4 = parserCursor.getUpperBound();
        for (int i2 = n3; i2 < n4 && TokenParser.isWhitespace(c2 = charArrayBuffer.charAt(i2)); ++i2) {
            ++n2;
        }
        parserCursor.updatePos(n2);
    }

    public void copyContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet, StringBuilder stringBuilder) {
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getPos();
        int n4 = parserCursor.getUpperBound();
        for (int i2 = n3; i2 < n4; ++i2) {
            char c2 = charArrayBuffer.charAt(i2);
            if (bitSet != null && bitSet.get(c2) || TokenParser.isWhitespace(c2)) break;
            ++n2;
            stringBuilder.append(c2);
        }
        parserCursor.updatePos(n2);
    }

    public void copyUnquotedContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet, StringBuilder stringBuilder) {
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getPos();
        int n4 = parserCursor.getUpperBound();
        for (int i2 = n3; i2 < n4; ++i2) {
            char c2 = charArrayBuffer.charAt(i2);
            if (bitSet != null && bitSet.get(c2) || TokenParser.isWhitespace(c2) || c2 == '\"') break;
            ++n2;
            stringBuilder.append(c2);
        }
        parserCursor.updatePos(n2);
    }

    public void copyQuotedContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, StringBuilder stringBuilder) {
        if (parserCursor.atEnd()) {
            return;
        }
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getPos();
        int n4 = parserCursor.getUpperBound();
        char c2 = charArrayBuffer.charAt(n2);
        if (c2 != '\"') {
            return;
        }
        ++n2;
        boolean bl = false;
        int n5 = ++n3;
        while (n5 < n4) {
            c2 = charArrayBuffer.charAt(n5);
            if (bl) {
                if (c2 != '\"' && c2 != '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c2);
                bl = false;
            } else {
                if (c2 == '\"') {
                    ++n2;
                    break;
                }
                if (c2 == '\\') {
                    bl = true;
                } else if (c2 != '\r' && c2 != '\n') {
                    stringBuilder.append(c2);
                }
            }
            ++n5;
            ++n2;
        }
        parserCursor.updatePos(n2);
    }
}

